// RendererD3D9.cpp: implementation of the CRendererD3D9 class.
//
// created by Unwinder
//////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "RendererD3D9.h"
//////////////////////////////////////////////////////////////////////
#define SAFE_RELEASE(ptr) if (ptr) { ptr->Release(); ptr = NULL; } 
//////////////////////////////////////////////////////////////////////
struct SOLIDVERTEX
{
    float			x, y, z, h;
    D3DCOLOR		color;
};
//////////////////////////////////////////////////////////////////////
#define D3DFVF_SOLIDVERTEX (D3DFVF_XYZRHW | D3DFVF_DIFFUSE)
//////////////////////////////////////////////////////////////////////
CRendererD3D9::CRendererD3D9()
{
	m_hWnd			= NULL;
	m_lpd3d			= NULL; 
	m_lpd3dDevice	= NULL; 
}
//////////////////////////////////////////////////////////////////////
CRendererD3D9::~CRendererD3D9()
{
	Uninit();
}
//////////////////////////////////////////////////////////////////////
BOOL CRendererD3D9::Init(HWND hWnd)
{
	Uninit();

	m_hWnd = hWnd;

	m_lpd3d = Direct3DCreate9(D3D_SDK_VERSION);
	if (!m_lpd3d)
		return FALSE;

	ZeroMemory(&m_d3dpp, sizeof(m_d3dpp));
	m_d3dpp.Windowed				= TRUE;
	m_d3dpp.SwapEffect				= D3DSWAPEFFECT_COPY;
	m_d3dpp.BackBufferFormat		= D3DFMT_UNKNOWN;
	m_d3dpp.EnableAutoDepthStencil	= TRUE;
	m_d3dpp.AutoDepthStencilFormat	= D3DFMT_D16;
	m_d3dpp.PresentationInterval	= D3DPRESENT_INTERVAL_IMMEDIATE;
	m_d3dpp.MultiSampleType			= D3DMULTISAMPLE_NONE;

	if (FAILED(m_lpd3d->CreateDevice(0, D3DDEVTYPE_HAL, m_hWnd, D3DCREATE_HARDWARE_VERTEXPROCESSING, &m_d3dpp, &m_lpd3dDevice)))
	{
		SAFE_RELEASE(m_lpd3d);

		return FALSE;
	}

	return TRUE;
}
//////////////////////////////////////////////////////////////////////
void CRendererD3D9::Uninit()
{
	SAFE_RELEASE(m_lpd3dDevice);
	SAFE_RELEASE(m_lpd3d);
}
//////////////////////////////////////////////////////////////////////
void CRendererD3D9::Reset(int x, int y)
{
	if (m_lpd3dDevice)
	{
		m_d3dpp.BackBufferWidth		= x;
		m_d3dpp.BackBufferHeight	= y;

		m_lpd3dDevice->Reset(&m_d3dpp);
	}
}
//////////////////////////////////////////////////////////////////////
void CRendererD3D9::Render(DWORD dwColor)
{
	HRESULT err;

	if (m_lpd3dDevice)
	{
		m_lpd3dDevice->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, SwapRGB(dwColor), 1.0f, 0);

		if (SUCCEEDED(m_lpd3dDevice->BeginScene()))
		{
			m_lpd3dDevice->SetFVF(D3DFVF_SOLIDVERTEX);

			SOLIDVERTEX vertex;
			vertex.x		= 0;
			vertex.y		= 0;
			vertex.z		= 0;
			vertex.h		= 1;
			vertex.color	= SwapRGB(dwColor);

			m_lpd3dDevice->DrawPrimitiveUP(D3DPT_POINTLIST, 1, &vertex, sizeof(SOLIDVERTEX));
				//note: 3D application must render at least 1 primitive to get OSD displayed, so we render a point

			m_lpd3dDevice->EndScene();
		}

		err = m_lpd3dDevice->Present(NULL, NULL, NULL, NULL);

		if ((err == D3DERR_DEVICELOST) || 
			(err == D3DERR_INVALIDCALL))
		{
			if (m_lpd3dDevice->TestCooperativeLevel() == D3DERR_DEVICENOTRESET)
			{
				CRect cr;
				GetClientRect(m_hWnd, &cr);

				Reset(cr.Width(), cr.Height());
			}
		}
	}
}
//////////////////////////////////////////////////////////////////////
DWORD CRendererD3D9::SwapRGB(DWORD dwColor)
{
	return (0xFF & (dwColor>>16)) | (dwColor & 0xFF00) | ((dwColor & 0xFF)<<16);
}
//////////////////////////////////////////////////////////////////////
